/*
 * CRfePUR.h
 *
 *  Created on: 11.05.2009
 *      Author: stefan.detter
 */

#ifndef QRFERFEPURREADER_H_
#define QRFERFEPURREADER_H_

#include "QrfeRfeReader.h"
#include "../QrfeGen2AdvancedManipulatorInterface.h"

#include <QrfeTrace>

class QrfeProtocolHandlerRFE;

class QrfeRfePurReader : public QrfeRfeReader, QrfeGen2AdvancedManipulatorInterface
{
	Q_OBJECT

public:
	QrfeRfePurReader(QrfeProtocolHandlerRFE* ph, QObject* parent = 0);
	virtual ~QrfeRfePurReader();

	virtual QrfeGlobal::Result readSettings( );

	QStringList rssiChildNames();

	QrfeGlobal::Result setUpdateFlag();

	QrfeGlobal::Result inventoryMode ( ushort &mode );
	QrfeGlobal::Result setInventoryMode ( ushort mode );

	QrfeGlobal::Result powerSafe ( bool &on, ushort &interval);
	QrfeGlobal::Result setPowerSafe ( bool on, ushort interval );

	QrfeGlobal::Result powerSafeCount ( ushort &count);
	QrfeGlobal::Result setPowerSafeCount ( ushort count );

	QrfeGlobal::Result rssiEnabled ( bool &on );
	QrfeGlobal::Result setRssiEnabled ( bool on );

	QrfeGlobal::Result tagIdHandler ( uchar &handler );
	QrfeGlobal::Result setTagIdHandler ( uchar handler );

	QrfeGlobal::Result readFrequencyEnabled ( bool &on );
	QrfeGlobal::Result setReadFrequencyEnabled ( bool on );

	QrfeGlobal::Result modulationDepth ( uchar &percent );
	QrfeGlobal::Result setModulationDepth ( uchar percent );

	QrfeGlobal::Result linkFrequency ( uchar &lf );
	QrfeGlobal::Result setLinkFrequency ( uchar lf );

	QrfeGlobal::Result coding ( uchar &coding );
	QrfeGlobal::Result setCoding ( uchar coding );

    QrfeGlobal::Result longPreamble ( bool &longPreamble );
    QrfeGlobal::Result setLongPreamble (bool longPreamble );

	QrfeGlobal::Result epcSize ( uchar &epcSize );
	QrfeGlobal::Result setEpcSize ( uchar epcSize );

    QrfeGlobal::Result sendRN16( bool &on );
    QrfeGlobal::Result setSendRN16 ( bool on );

    QrfeGlobal::Result sendHandle( bool &on );
	QrfeGlobal::Result setSendHandle ( bool on );

	QrfeGlobal::Result sendPC( bool &on );
	QrfeGlobal::Result setSendPC ( bool on );

	QrfeGlobal::Result postDetectReadParams ( bool &on, uchar &memBank, ushort &address, uchar &size, QByteArray& password );
	QrfeGlobal::Result setPostDetectReadParams ( bool on, uchar memBank, ushort address, uchar size, QByteArray password );

	QrfeGlobal::Result q( uchar &initialQ, uchar &minimalQ, uchar &maximalQ );
	QrfeGlobal::Result setQ ( uchar initialQ, uchar minimalQ, uchar maximalQ );

	QrfeGlobal::Result qMethod( uchar &qMethod );
	QrfeGlobal::Result setQMethod ( uchar qMethod );

	QrfeGlobal::Result session( uchar &session );
	QrfeGlobal::Result setSession ( uchar session );

	QrfeGlobal::Result inventoryRounds( uchar &invRounds );
	QrfeGlobal::Result setInventoryRounds ( uchar invRounds );

	QrfeGlobal::Result selectionMask1( uchar &memBank, ulong& address, uchar& size, QByteArray& mask );
	QrfeGlobal::Result setSelectionMask1( uchar memBank, ulong address, uchar size, const QByteArray mask );

	QrfeGlobal::Result selectionMask2( uchar &memBank, ulong& address, uchar& size, QByteArray& mask );
	QrfeGlobal::Result setSelectionMask2( uchar memBank, ulong address, uchar size, const QByteArray mask );

    QrfeGlobal::Result queryNxpBrandID( bool &on );
    QrfeGlobal::Result setQueryNxpBrandID ( bool on );


	QrfeGlobal::Result as399xGconstant( uchar &G );

	QrfeGlobal::Result setTestFrequency ( uint freq );

	QrfeGlobal::Result measureReflectedPower ( uint freq, ushort time, char &chI, char &chQ, uchar &G );
	QrfeGlobal::Result measureRSSILevels ( uint freq, ushort time, uchar &rawQ, uchar &rawI, char &dBm );

	QrfeGlobal::Result as399xRegister( QByteArray &regs );

	QrfeGlobal::Result minimumAttenuation ( uchar &minAtt );
	QrfeGlobal::Result setMinimumAttenuation ( uchar minAtt );

	QrfeGlobal::Result frequencyOffset ( long &offset );
	QrfeGlobal::Result setFrequencyOffset ( long offset );

	QrfeGlobal::Result defaultFrequencyListIndex ( uchar &index );
	QrfeGlobal::Result setDefaultFrequencyListIndex ( uchar index );

	QrfeGlobal::Result defaultModulatorSettings ( ulong &modSet );
	QrfeGlobal::Result setDefaultModulatorSettings ( ulong modSet );

    QrfeGlobal::Result maxAntennaCount ( uchar &count );
    QrfeGlobal::Result setAntennaCount ( uchar count );

    QrfeGlobal::Result autoReflectedPowerMeasurementData ( uchar &time, uchar &cycles, short &threshold );
    QrfeGlobal::Result setAutoReflectedPowerMeasurementData ( uchar time, uchar cycles, short threshold );

    QrfeGlobal::Result powerSafeRequiredSettings ( bool &required, ushort &minTime, ushort &maxCount);
    QrfeGlobal::Result setPowerSafeRequiredSettings ( bool required, ushort minTime, ushort maxCount );

    QrfeGlobal::Result referenceFrequency(uchar &refFreq);
    QrfeGlobal::Result setReferenceFrequency ( uchar refFreq );

	virtual QrfeGlobal::TMIResult readFromTag ( const QString& tagId, uchar mem_bank, ushort address, const QByteArray& passwd, uchar count, QByteArray &data );
	virtual QrfeGlobal::TMIResult readMultipleFromTag ( const QString& tagId, QList<uchar> mem_bank, QList<ushort> address, QList<QByteArray> passwd, QList<uchar> count, QList<QByteArray> &data );
    virtual QrfeGlobal::TMIResult writeToTag ( const QString& tagId, uchar mem_bank, ushort address, const QByteArray& passwd, const QByteArray& data, bool retry = true );

	virtual QrfeGlobal::TMIResult lockTag ( const QString& tagId, uchar mode, uchar memory, const QByteArray& passwd );
	virtual QrfeGlobal::TMIResult killTag ( const QString& tagId, const QByteArray& killPassword  );

	virtual QrfeGlobal::TMIResult blockWriteToTag ( const QByteArray& tagId, uchar mem_bank, ushort address, const QByteArray& passwd, uchar blockSize, const QByteArray& data );

	virtual QrfeGlobal::TMIResult getTagHandle ( const QString& tagId, QByteArray &handle );
	virtual QrfeGlobal::TMIResult readFromHandle ( const QByteArray& handle, uchar mem_bank, ushort address, const QByteArray& passwd, uchar count, QByteArray &data );
	virtual QrfeGlobal::TMIResult writeToHandle ( const QByteArray& handle, uchar mem_bank, ushort address, const QByteArray& passwd, const QByteArray& data );
	virtual QrfeGlobal::TMIResult blockWriteToHandle ( const QByteArray& handle, uchar mem_bank, ushort address, const QByteArray& passwd, uchar blockSize, const QByteArray& data );
	virtual QrfeGlobal::TMIResult customGen2Command ( const QByteArray& handle, const QByteArray& command, const QByteArray& passwd, uchar txBitCount, const QByteArray& txBits, bool& headerBit, QByteArray& rxBytes );


	virtual QrfeGlobal::TMIResult nxp_setReadProtect ( const QString& tagId, const QByteArray& passwd );
	virtual QrfeGlobal::TMIResult nxp_resetReadProtect ( const QString& tagId, const QByteArray& passwd );
	virtual QrfeGlobal::TMIResult nxp_sendCmdToCtrler ( const QString& tagId, uchar cmd, const QByteArray& cmdData );

	virtual QrfeTagManipulatorInterface* 	getTagManipulator();
	virtual QrfeReaderInterface*  			getReaderInterface();

    virtual bool tagManipulatorCanReadToEnd();
    virtual uint tagManipulatorMaxBufferSize();

	virtual void 	getRSSIChannels(QList<QString>& names, QList<long>& minimum, QList<long>& maximum, QList<QString>& units);
	virtual QString getNotificationName(uchar id);
	virtual void 	getApplicationInformation( const QByteArray& data, QMap<uint,QPair<QString,QString> >& genericInfo);


public slots:
	virtual void notificationSlot ( const uchar id, const QByteArray& data );

private slots:
	void acknowledgeAS399xStatusBit();

protected:
	virtual bool filter_statusRegisterChanged(const qulonglong statusRegister);

	virtual QStringList statusStrings() const;

private:
	virtual QByteArray 	interpretRSSItoPercent(const QByteArray& tagId, QByteArray rssi);
	virtual QString	 	interpretTriggerId(const QByteArray& tagId, uchar trigger);
	virtual QString	 	interpretStateName(const QByteArray& tagId, ushort state);

	QrfeGlobal::TMIResult translateGen2ProtocolHandlerResult(QrfeGlobal::Result res);

	const static QStringList	m_rssiChildNames;
	const static int			m_rssiChildMin;
	const static int			m_rssiChildMax;

	ulong 		m_as399xResetCount;

	bool 		m_retreivedValidG;
	uchar 		m_as399xGconstant;

public:

	typedef enum {
		GEN2_Fast_Multi_Tag = 0x00,
		GEN2_Fast_Single_Tag = 0x01,
		GEN2_Standard_Multi_Tag = 0x02,
		GEN2_NXP_Read_Protect = 0x03,
		GEN2_Standard_Single_Tag = 0x04,
	} InventoryMode;

	typedef enum {
		Send_Tag_Id_Immediately = 0x00,
		Send_Tag_Id_Once = 0x01,
		Send_Tag_Id_Immediately_And_Stop = 0x02
	} TagIdBehavior;

	typedef enum {
		NOTIFICATION_ID_ANTENNA_POWER_CHANGED		= 0,
		NOTIFICATION_ID_FREQUENCY_CHANGED			= 1,
		NOTIFICATION_ID_INVENTORY_ROUND_ENDED		= 2,
		NOTIFICATION_ID_LBT_RSSI_VALUE_MEASURED		= 3,
        NOTIFICATION_ID_ANTENNA_CHANNEL_CHANGED     = 4,
        NOTIFICATION_ID_ANTENNA_RFP_VALUE_MEASURED 	= 5,
        NOTIFICATION_ID_ANTENNA_RFP_ERROR           = 6,
        NOTIFICATION_ID_DEBUG_CODES                 = 31,
    } NotificationID;

	typedef enum {
		STATUSBIT_AT91_SPURIOUS_BIT					= 0,
		STATUSBIT_EEPROM_STATUS_BIT					= 4,
        STATUSBIT_ANTENNA_TO_HIGH_RFP               = 8,
		STATUSBIT_AS399X_STATUS_BIT					= 16,
		STATUSBIT_AS399X_COM_ERROR_BIT				= 17,
		STATUSBIT_AS399X_SET_FREQUENCY_PROBLEM		= 18,
		STATUSBIT_AS399X_WRONG_FREQUENCY_PROBLEM	= 19,
		STATUSBIT_AS399X_ANTENNA_SET_PROBLEM		= 20,
		STATUSBIT_AS399X_ERROR_ON_INIT				= 21,
        STATUSBIT_AS399X_PLL_NOT_LOCKED             = 22,
		STATUSBIT_GEN2_CRC_ERROR_BIT				= 32,
	} StatusBitId;
};

#endif /* QRFERFEPURREADER_H_ */
